#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "map.h"
#include "gmstuff.h"
#include "switchstuff.h"
#include "linkstuff.h"

char *Mapfile;
char *Listfile;

void
parse_args(
  int argc,
  char **argv)
{
  int c;
  extern char *optarg;

  Mapfile = NULL;
  Listfile = NULL;

  while ((c = getopt(argc, argv, "m:l:")) != EOF) switch (c) {

  case 'm':	/* map file (input) */
    Mapfile = optarg;
    break;

  case 'l':	/* list file (input) */
    Listfile = optarg;
    break;
  }


  if (Mapfile == NULL || Listfile == NULL) {
    fprintf(stderr, "usage: submap -m map_file -l list_file\n");
    exit(1);
  }
}

int *
read_list_file(struct mapfile *mp, char *fname)
{
  int *include;
  char buf[80];
  FILE *fp;
  int i;
  int imac[6];
  char mac[6];
  int count;
  int rc;

  /*
   * the include array is rather a hack.  the 1st half of the array
   * maps from host mapfile index to new index. it's +1 so it can be
   * used as a flag.
   * the 2nd half of the file maps the other way.
   * i.e. include[old_index] = new_index+1
   *      include[mp->nhost + new_index] = old_index
   * and  include[mp->nhost*2] = entries in list file
   */
  include = (int *) calloc((mp->nhost * 2) + 1, sizeof(int));
  assert(include != NULL);

  fp = fopen(fname, "r");
  assert(fp != NULL);

  count = 0;
  while (fgets(buf, sizeof(buf), fp) != NULL) {
    rc = sscanf(buf, "%x:%x:%x:%x:%x:%x",
      &imac[0], &imac[1], &imac[2], &imac[3], &imac[4], &imac[5]);
    assert(rc == 6);
    for (i=0; i<6; ++i) mac[i] = imac[i];

    for (i=0; i<mp->nhost; ++i) {
      if (memcmp(mac, mp->host[i].mac_addr, 6) == 0) {
        include[mp->nhost + count] = i;
	include[i] = ++count;
	break;
      }
    }
    if (i >= mp->nhost) {
      printf("warning: %x:%x:%x:%x:%x:%x not in map\n",
	      mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    }
  }
  
  include[2*mp->nhost] = count;
  fclose(fp);

  return include;
}

void
write_submap(struct mapfile *mp, int *include)
{
  int i;
  int new_num_hosts;
  int *old2new;
  char xbarname[80];

  /* see above for layout of include */
  old2new = include + mp->nhost;
  new_num_hosts = include[2*mp->nhost];

  /* print the host section */
  for (i=0; i<new_num_hosts; ++i) {
    printf("h - h%d\n", i);
    printf("%d\n", mp->host[old2new[i]].nport);
    printf("0 s - %s %d\n",
	   mp->host[old2new[i]].xbar->name,
	   mp->host[old2new[i]].port);
    printf("address %x:%x:%x:%x:%x:%x\n",
	   mp->host[old2new[i]].mac_addr[0],
	   mp->host[old2new[i]].mac_addr[1],
	   mp->host[old2new[i]].mac_addr[2],
	   mp->host[old2new[i]].mac_addr[3],
	   mp->host[old2new[i]].mac_addr[4],
	   mp->host[old2new[i]].mac_addr[5]);
    printf("hostType 1\n");
    puts("");
  }

  /* fix up xbar structs */
  for (i=0; i<mp->nxbar; ++i) {
    struct xbar *xp;
    int p;

    xp = mp->xbar + i;

    xp->nport = 0;
    xp->firstport = -1;
    for (p=0; p<MAX_XBAR_PORT; ++p) {
      if ((xp->port[p].conn_type == CONN_XBAR) ||
	  (xp->port[p].conn_type == CONN_HOST &&
            include[xp->port[p].ptr.h - mp->host] > 0)) {
	++xp->nport;
        if (xp->firstport == -1) xp->firstport = p;
      }
    }
  }

  /* print the xbar section */
  for (i=0; i<mp->nxbar; ++i) {
    struct xbar *xp;
    int p;

    sprintf(xbarname, "x%d", i);
    xp = mp->xbar + symtab_lookup(mp->xsyms, xbarname);

    printf("s - %s\n", xp->name);
    printf("%d\n", xp->nport);

    /* print port connection info if > 0 connected */
    if (xp->nport > 0) {
      for (p=xp->firstport; p<MAX_XBAR_PORT; ++p) {

	/* an xbar connection */
	if (xp->port[p].conn_type == CONN_XBAR) {
	  printf("%d s - %s %d\n", 
	         p - xp->firstport,
	         xp->port[p].ptr.x->name,
	         xp->port[p].conn_port - xp->port[p].ptr.x->firstport);

	/* a host connection - translate to our new host numbering scheme */
	/* remember that we have to subtract 1 from host index */
	} else if (xp->port[p].conn_type == CONN_HOST &&
	           include[xp->port[p].ptr.h - mp->host] > 0) {
	  printf("%d h - h%d 0\n", 
	         p - xp->firstport,
	         include[xp->port[p].ptr.h - mp->host]-1);
        }
      }
      puts("");
    }
  }
}

int
main(
  int argc,
  char **argv)
{
  struct mapfile mf;
  int *include;

  parse_args(argc, argv);

  mf.name = Mapfile;
  load_map_file(&mf);

  include = read_list_file(&mf, Listfile);
  write_submap(&mf, include);

  return 0;
}

int
get_gm_host_name(unsigned char *m, char *h)
{
  return -1;
}
